#pragma once

#include "InternalClasses.h"

namespace PcanIsoTpExample {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;

	using namespace Peak::Can::IsoTp;

	/// <summary>
	/// Form class handling configuration of an ISO-TP mapping.
	/// </summary>
	public ref class FormMapping : public System::Windows::Forms::Form
	{
		/// <summary>
		/// The configured mapping.
		/// </summary>
		public: PcanIsoTpExample::MappingStatus ^m_mapping;
		/// <summary>
		/// Default constructor
		/// </summary>
		FormMapping(void)
		{
			InitializeComponent();
			
			m_mapping = gcnew MappingStatus(0x00, 0x00, TPCANTPIdType::PCANTP_ID_CAN_11BIT, TPCANTPFormatType::PCANTP_FORMAT_UNKNOWN,
				TPCANTPMessageType::PCANTP_MESSAGE_UNKNOWN, TPCANTPAddressingType::PCANTP_ADDRESSING_UNKNOWN, 0x00, 0x00, 0x00);

			// fill target type combobox
			comboBoxTargetType->Items->Add(gcnew ComboBoxItem(
				"PCANTP_ADDRESSING_PHYSICAL",
				TPCANTPAddressingType::PCANTP_ADDRESSING_PHYSICAL));
			comboBoxTargetType->Items->Add(gcnew ComboBoxItem(
				"PCANTP_ADDRESSING_FUNCTIONAL",
				TPCANTPAddressingType::PCANTP_ADDRESSING_FUNCTIONAL));
			// fill message type combobox
			fillComboBoxMsgType(m_mapping->m_canIdType);
			// fill format type combobox
			fillComboBoxFormatType(m_mapping->m_canIdType, m_mapping->m_msgType);

			buttonOk->Enabled = checkMapping();
		}

		protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~FormMapping()
		{
			if (components)
			{
				delete components;
			}
		}

#pragma region Windows Form Designer Members Generated Code
	private: System::Windows::Forms::Button^  buttonOk;
	private: System::Windows::Forms::Button^  buttonCancel;
	private: System::Windows::Forms::Label^  labelRemoteAddr;
	private: System::Windows::Forms::Label^  labelTargetAddr;
	private: System::Windows::Forms::Label^  labelSrcAddr;
	private: System::Windows::Forms::Label^  labelTargetType;
	private: System::Windows::Forms::Label^  labelMsgType;
	private: System::Windows::Forms::Label^  labelCanIdType;
	private: System::Windows::Forms::RadioButton^  radioButtonCanId29b;
	private: System::Windows::Forms::RadioButton^  radioButtonCanId11b;
	private: System::Windows::Forms::NumericUpDown^  numericUpDownCanIdResp;
	private: System::Windows::Forms::NumericUpDown^  numericUpDownCanId;
	private: System::Windows::Forms::Label^  labelFormat;
	private: System::Windows::Forms::Label^  labelCanId;
	private: System::Windows::Forms::Label^  labelCanIdResp;
	private: System::Windows::Forms::NumericUpDown^  numericUpDownRemoteAddr;
	private: System::Windows::Forms::NumericUpDown^  numericUpDownTargetAddr;
	private: System::Windows::Forms::NumericUpDown^  numericUpDownSourceAddr;
	private: System::Windows::Forms::ComboBox^  comboBoxTargetType;
	private: System::Windows::Forms::ComboBox^  comboBoxMsgType;
	private: System::Windows::Forms::ComboBox^  comboBoxFormat;
	/// <summary>
	/// Required designer variable.
	/// </summary>
	private: System::ComponentModel::Container ^components;
#pragma endregion

#pragma region Windows Form Designer generated code
	/// <summary>
	/// Required method for Designer support - do not modify
	/// the contents of this method with the code editor.
	/// </summary>
	void InitializeComponent(void)
	{
		this->buttonOk = (gcnew System::Windows::Forms::Button());
		this->buttonCancel = (gcnew System::Windows::Forms::Button());
		this->labelRemoteAddr = (gcnew System::Windows::Forms::Label());
		this->labelTargetAddr = (gcnew System::Windows::Forms::Label());
		this->labelSrcAddr = (gcnew System::Windows::Forms::Label());
		this->labelTargetType = (gcnew System::Windows::Forms::Label());
		this->labelMsgType = (gcnew System::Windows::Forms::Label());
		this->labelCanIdType = (gcnew System::Windows::Forms::Label());
		this->radioButtonCanId29b = (gcnew System::Windows::Forms::RadioButton());
		this->radioButtonCanId11b = (gcnew System::Windows::Forms::RadioButton());
		this->numericUpDownCanIdResp = (gcnew System::Windows::Forms::NumericUpDown());
		this->numericUpDownCanId = (gcnew System::Windows::Forms::NumericUpDown());
		this->labelFormat = (gcnew System::Windows::Forms::Label());
		this->labelCanId = (gcnew System::Windows::Forms::Label());
		this->labelCanIdResp = (gcnew System::Windows::Forms::Label());
		this->numericUpDownRemoteAddr = (gcnew System::Windows::Forms::NumericUpDown());
		this->numericUpDownTargetAddr = (gcnew System::Windows::Forms::NumericUpDown());
		this->numericUpDownSourceAddr = (gcnew System::Windows::Forms::NumericUpDown());
		this->comboBoxTargetType = (gcnew System::Windows::Forms::ComboBox());
		this->comboBoxMsgType = (gcnew System::Windows::Forms::ComboBox());
		this->comboBoxFormat = (gcnew System::Windows::Forms::ComboBox());
		(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownCanIdResp))->BeginInit();
		(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownCanId))->BeginInit();
		(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownRemoteAddr))->BeginInit();
		(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownTargetAddr))->BeginInit();
		(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownSourceAddr))->BeginInit();
		this->SuspendLayout();
		// 
		// buttonOk
		// 
		this->buttonOk->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Right));
		this->buttonOk->DialogResult = System::Windows::Forms::DialogResult::OK;
		this->buttonOk->Location = System::Drawing::Point(278, 256);
		this->buttonOk->Name = L"buttonOk";
		this->buttonOk->Size = System::Drawing::Size(75, 23);
		this->buttonOk->TabIndex = 41;
		this->buttonOk->Text = L"OK";
		this->buttonOk->UseVisualStyleBackColor = true;
		this->buttonOk->Click += gcnew System::EventHandler(this, &FormMapping::buttonOk_Click);
		// 
		// buttonCancel
		// 
		this->buttonCancel->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Right));
		this->buttonCancel->DialogResult = System::Windows::Forms::DialogResult::Cancel;
		this->buttonCancel->Location = System::Drawing::Point(359, 256);
		this->buttonCancel->Name = L"buttonCancel";
		this->buttonCancel->Size = System::Drawing::Size(75, 23);
		this->buttonCancel->TabIndex = 42;
		this->buttonCancel->Text = L"Cancel";
		this->buttonCancel->UseVisualStyleBackColor = true;
		// 
		// labelRemoteAddr
		// 
		this->labelRemoteAddr->AutoSize = true;
		this->labelRemoteAddr->Location = System::Drawing::Point(12, 219);
		this->labelRemoteAddr->Name = L"labelRemoteAddr";
		this->labelRemoteAddr->Size = System::Drawing::Size(113, 13);
		this->labelRemoteAddr->TabIndex = 39;
		this->labelRemoteAddr->Text = L"Remote address (hex):";
		// 
		// labelTargetAddr
		// 
		this->labelTargetAddr->AutoSize = true;
		this->labelTargetAddr->Location = System::Drawing::Point(12, 193);
		this->labelTargetAddr->Name = L"labelTargetAddr";
		this->labelTargetAddr->Size = System::Drawing::Size(107, 13);
		this->labelTargetAddr->TabIndex = 37;
		this->labelTargetAddr->Text = L"Target address (hex):";
		// 
		// labelSrcAddr
		// 
		this->labelSrcAddr->AutoSize = true;
		this->labelSrcAddr->Location = System::Drawing::Point(12, 167);
		this->labelSrcAddr->Name = L"labelSrcAddr";
		this->labelSrcAddr->Size = System::Drawing::Size(110, 13);
		this->labelSrcAddr->TabIndex = 35;
		this->labelSrcAddr->Text = L"Source address (hex):";
		// 
		// labelTargetType
		// 
		this->labelTargetType->AutoSize = true;
		this->labelTargetType->Location = System::Drawing::Point(12, 88);
		this->labelTargetType->Name = L"labelTargetType";
		this->labelTargetType->Size = System::Drawing::Size(118, 13);
		this->labelTargetType->TabIndex = 29;
		this->labelTargetType->Text = L"Target addressing type:";
		// 
		// labelMsgType
		// 
		this->labelMsgType->AutoSize = true;
		this->labelMsgType->Location = System::Drawing::Point(12, 34);
		this->labelMsgType->Name = L"labelMsgType";
		this->labelMsgType->Size = System::Drawing::Size(76, 13);
		this->labelMsgType->TabIndex = 25;
		this->labelMsgType->Text = L"Message type:";
		// 
		// labelCanIdType
		// 
		this->labelCanIdType->AutoSize = true;
		this->labelCanIdType->Location = System::Drawing::Point(12, 11);
		this->labelCanIdType->Name = L"labelCanIdType";
		this->labelCanIdType->Size = System::Drawing::Size(69, 13);
		this->labelCanIdType->TabIndex = 22;
		this->labelCanIdType->Text = L"CAN ID type:";
		// 
		// radioButtonCanId29b
		// 
		this->radioButtonCanId29b->AutoSize = true;
		this->radioButtonCanId29b->Location = System::Drawing::Point(205, 9);
		this->radioButtonCanId29b->Name = L"radioButtonCanId29b";
		this->radioButtonCanId29b->Size = System::Drawing::Size(56, 17);
		this->radioButtonCanId29b->TabIndex = 24;
		this->radioButtonCanId29b->TabStop = true;
		this->radioButtonCanId29b->Text = L"29 bits";
		this->radioButtonCanId29b->UseVisualStyleBackColor = true;
		this->radioButtonCanId29b->CheckedChanged += gcnew System::EventHandler(this, &FormMapping::radioButtonCanId_CheckedChanged);
		this->radioButtonCanId29b->Leave += gcnew System::EventHandler(this, &FormMapping::uiComponent_Leave);
		// 
		// radioButtonCanId11b
		// 
		this->radioButtonCanId11b->AutoSize = true;
		this->radioButtonCanId11b->Location = System::Drawing::Point(143, 9);
		this->radioButtonCanId11b->Name = L"radioButtonCanId11b";
		this->radioButtonCanId11b->Size = System::Drawing::Size(56, 17);
		this->radioButtonCanId11b->TabIndex = 23;
		this->radioButtonCanId11b->TabStop = true;
		this->radioButtonCanId11b->Text = L"11 bits";
		this->radioButtonCanId11b->UseVisualStyleBackColor = true;
		this->radioButtonCanId11b->CheckedChanged += gcnew System::EventHandler(this, &FormMapping::radioButtonCanId_CheckedChanged);
		this->radioButtonCanId11b->Leave += gcnew System::EventHandler(this, &FormMapping::uiComponent_Leave);
		// 
		// numericUpDownCanIdResp
		// 
		this->numericUpDownCanIdResp->Anchor = static_cast<System::Windows::Forms::AnchorStyles>(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Left)
			| System::Windows::Forms::AnchorStyles::Right));
		this->numericUpDownCanIdResp->Hexadecimal = true;
		this->numericUpDownCanIdResp->Location = System::Drawing::Point(143, 138);
		this->numericUpDownCanIdResp->Name = L"numericUpDownCanIdResp";
		this->numericUpDownCanIdResp->Size = System::Drawing::Size(291, 20);
		this->numericUpDownCanIdResp->TabIndex = 34;
		this->numericUpDownCanIdResp->ValueChanged += gcnew System::EventHandler(this, &FormMapping::numericUpDownComponents_ValueChanged);
		this->numericUpDownCanIdResp->Leave += gcnew System::EventHandler(this, &FormMapping::uiComponent_Leave);
		// 
		// numericUpDownCanId
		// 
		this->numericUpDownCanId->Anchor = static_cast<System::Windows::Forms::AnchorStyles>(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Left)
			| System::Windows::Forms::AnchorStyles::Right));
		this->numericUpDownCanId->Hexadecimal = true;
		this->numericUpDownCanId->Location = System::Drawing::Point(143, 112);
		this->numericUpDownCanId->Name = L"numericUpDownCanId";
		this->numericUpDownCanId->Size = System::Drawing::Size(291, 20);
		this->numericUpDownCanId->TabIndex = 32;
		this->numericUpDownCanId->ValueChanged += gcnew System::EventHandler(this, &FormMapping::numericUpDownComponents_ValueChanged);
		this->numericUpDownCanId->Leave += gcnew System::EventHandler(this, &FormMapping::uiComponent_Leave);
		// 
		// labelFormat
		// 
		this->labelFormat->AutoSize = true;
		this->labelFormat->Location = System::Drawing::Point(12, 61);
		this->labelFormat->Name = L"labelFormat";
		this->labelFormat->Size = System::Drawing::Size(65, 13);
		this->labelFormat->TabIndex = 27;
		this->labelFormat->Text = L"Format type:";
		// 
		// labelCanId
		// 
		this->labelCanId->AutoSize = true;
		this->labelCanId->Location = System::Drawing::Point(12, 114);
		this->labelCanId->Name = L"labelCanId";
		this->labelCanId->Size = System::Drawing::Size(72, 13);
		this->labelCanId->TabIndex = 31;
		this->labelCanId->Text = L"CAN ID (hex):";
		// 
		// labelCanIdResp
		// 
		this->labelCanIdResp->AutoSize = true;
		this->labelCanIdResp->Location = System::Drawing::Point(12, 140);
		this->labelCanIdResp->Name = L"labelCanIdResp";
		this->labelCanIdResp->Size = System::Drawing::Size(118, 13);
		this->labelCanIdResp->TabIndex = 33;
		this->labelCanIdResp->Text = L"CAN ID response (hex):";
		// 
		// numericUpDownRemoteAddr
		// 
		this->numericUpDownRemoteAddr->Anchor = static_cast<System::Windows::Forms::AnchorStyles>(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Left)
			| System::Windows::Forms::AnchorStyles::Right));
		this->numericUpDownRemoteAddr->Hexadecimal = true;
		this->numericUpDownRemoteAddr->Location = System::Drawing::Point(143, 217);
		this->numericUpDownRemoteAddr->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) { 255, 0, 0, 0 });
		this->numericUpDownRemoteAddr->Name = L"numericUpDownRemoteAddr";
		this->numericUpDownRemoteAddr->Size = System::Drawing::Size(291, 20);
		this->numericUpDownRemoteAddr->TabIndex = 40;
		this->numericUpDownRemoteAddr->ValueChanged += gcnew System::EventHandler(this, &FormMapping::numericUpDownComponents_ValueChanged);
		this->numericUpDownRemoteAddr->Leave += gcnew System::EventHandler(this, &FormMapping::uiComponent_Leave);
		// 
		// numericUpDownTargetAddr
		// 
		this->numericUpDownTargetAddr->Anchor = static_cast<System::Windows::Forms::AnchorStyles>(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Left)
			| System::Windows::Forms::AnchorStyles::Right));
		this->numericUpDownTargetAddr->Hexadecimal = true;
		this->numericUpDownTargetAddr->Location = System::Drawing::Point(143, 191);
		this->numericUpDownTargetAddr->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) { 255, 0, 0, 0 });
		this->numericUpDownTargetAddr->Name = L"numericUpDownTargetAddr";
		this->numericUpDownTargetAddr->Size = System::Drawing::Size(291, 20);
		this->numericUpDownTargetAddr->TabIndex = 38;
		this->numericUpDownTargetAddr->ValueChanged += gcnew System::EventHandler(this, &FormMapping::numericUpDownComponents_ValueChanged);
		this->numericUpDownTargetAddr->Leave += gcnew System::EventHandler(this, &FormMapping::uiComponent_Leave);
		// 
		// numericUpDownSourceAddr
		// 
		this->numericUpDownSourceAddr->Anchor = static_cast<System::Windows::Forms::AnchorStyles>(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Left)
			| System::Windows::Forms::AnchorStyles::Right));
		this->numericUpDownSourceAddr->Hexadecimal = true;
		this->numericUpDownSourceAddr->Location = System::Drawing::Point(143, 165);
		this->numericUpDownSourceAddr->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) { 255, 0, 0, 0 });
		this->numericUpDownSourceAddr->Name = L"numericUpDownSourceAddr";
		this->numericUpDownSourceAddr->Size = System::Drawing::Size(291, 20);
		this->numericUpDownSourceAddr->TabIndex = 36;
		this->numericUpDownSourceAddr->ValueChanged += gcnew System::EventHandler(this, &FormMapping::numericUpDownComponents_ValueChanged);
		this->numericUpDownSourceAddr->Leave += gcnew System::EventHandler(this, &FormMapping::uiComponent_Leave);
		// 
		// comboBoxTargetType
		// 
		this->comboBoxTargetType->Anchor = static_cast<System::Windows::Forms::AnchorStyles>(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Left)
			| System::Windows::Forms::AnchorStyles::Right));
		this->comboBoxTargetType->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
		this->comboBoxTargetType->FormattingEnabled = true;
		this->comboBoxTargetType->Location = System::Drawing::Point(143, 85);
		this->comboBoxTargetType->Name = L"comboBoxTargetType";
		this->comboBoxTargetType->Size = System::Drawing::Size(291, 21);
		this->comboBoxTargetType->TabIndex = 30;
		this->comboBoxTargetType->SelectedIndexChanged += gcnew System::EventHandler(this, &FormMapping::comboBoxTargetType_SelectedIndexChanged);
		// 
		// comboBoxMsgType
		// 
		this->comboBoxMsgType->Anchor = static_cast<System::Windows::Forms::AnchorStyles>(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Left)
			| System::Windows::Forms::AnchorStyles::Right));
		this->comboBoxMsgType->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
		this->comboBoxMsgType->FormattingEnabled = true;
		this->comboBoxMsgType->Location = System::Drawing::Point(143, 31);
		this->comboBoxMsgType->Name = L"comboBoxMsgType";
		this->comboBoxMsgType->Size = System::Drawing::Size(291, 21);
		this->comboBoxMsgType->TabIndex = 26;
		this->comboBoxMsgType->SelectedIndexChanged += gcnew System::EventHandler(this, &FormMapping::comboBoxMsgType_SelectedIndexChanged);
		// 
		// comboBoxFormat
		// 
		this->comboBoxFormat->Anchor = static_cast<System::Windows::Forms::AnchorStyles>(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Left)
			| System::Windows::Forms::AnchorStyles::Right));
		this->comboBoxFormat->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
		this->comboBoxFormat->FormattingEnabled = true;
		this->comboBoxFormat->Location = System::Drawing::Point(143, 58);
		this->comboBoxFormat->Name = L"comboBoxFormat";
		this->comboBoxFormat->Size = System::Drawing::Size(291, 21);
		this->comboBoxFormat->TabIndex = 28;
		this->comboBoxFormat->SelectedIndexChanged += gcnew System::EventHandler(this, &FormMapping::comboBoxFormat_SelectedIndexChanged);
		// 
		// FormMapping
		// 
		this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
		this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
		this->ClientSize = System::Drawing::Size(446, 289);
		this->Controls->Add(this->buttonOk);
		this->Controls->Add(this->buttonCancel);
		this->Controls->Add(this->labelRemoteAddr);
		this->Controls->Add(this->labelTargetAddr);
		this->Controls->Add(this->labelSrcAddr);
		this->Controls->Add(this->labelTargetType);
		this->Controls->Add(this->labelMsgType);
		this->Controls->Add(this->labelCanIdType);
		this->Controls->Add(this->radioButtonCanId29b);
		this->Controls->Add(this->radioButtonCanId11b);
		this->Controls->Add(this->numericUpDownCanIdResp);
		this->Controls->Add(this->numericUpDownCanId);
		this->Controls->Add(this->labelFormat);
		this->Controls->Add(this->labelCanId);
		this->Controls->Add(this->labelCanIdResp);
		this->Controls->Add(this->numericUpDownRemoteAddr);
		this->Controls->Add(this->numericUpDownTargetAddr);
		this->Controls->Add(this->numericUpDownSourceAddr);
		this->Controls->Add(this->comboBoxTargetType);
		this->Controls->Add(this->comboBoxMsgType);
		this->Controls->Add(this->comboBoxFormat);
		this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::FixedDialog;
		this->MaximizeBox = false;
		this->MinimizeBox = false;
		this->Name = L"FormMapping";
		this->ShowIcon = false;
		this->ShowInTaskbar = false;
		this->StartPosition = System::Windows::Forms::FormStartPosition::CenterParent;
		this->Text = L"ISO-TP Mapping";
		(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownCanIdResp))->EndInit();
		(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownCanId))->EndInit();
		(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownRemoteAddr))->EndInit();
		(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownTargetAddr))->EndInit();
		(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownSourceAddr))->EndInit();
		this->ResumeLayout(false);
		this->PerformLayout();
	}
#pragma endregion
	
	/// <summary>
	/// Initializes the components with a pre-defined ISO-TP mapping
	/// </summary>
	/// <param name="mapping">The mapping used to initialize UI components (null for default settigns).</param>
	public: void initializeMapping(MappingStatus ^mapping)
	{
		int i;
		ComboBoxItem ^cbItem;

		if (mapping == nullptr)
			mapping = gcnew MappingStatus(0x00, 0x00, TPCANTPIdType::PCANTP_ID_CAN_11BIT, TPCANTPFormatType::PCANTP_FORMAT_UNKNOWN,
				TPCANTPMessageType::PCANTP_MESSAGE_UNKNOWN, TPCANTPAddressingType::PCANTP_ADDRESSING_UNKNOWN, 0x00, 0x00, 0x00);

		// select CAN ID Type in corresponding combobox
		switch (mapping->m_canIdType)
		{
		case TPCANTPIdType::PCANTP_ID_CAN_11BIT:
		default:
			radioButtonCanId11b->Checked = true;
			radioButtonCanId29b->Checked = false;
			break;
		case TPCANTPIdType::PCANTP_ID_CAN_29BIT:
			radioButtonCanId11b->Checked = false;
			radioButtonCanId29b->Checked = true;
			break;
		}
		// select message type in corresponding combobox
		for (i = 0; i < comboBoxMsgType->Items->Count; i++)
		{
			cbItem = (ComboBoxItem^)(comboBoxMsgType->Items[i]);
			if (safe_cast<TPCANTPMessageType>(cbItem->Data) == mapping->m_msgType)
			{
				comboBoxMsgType->SelectedIndex = i;
				break;
			}
		}
		// select format type in corresponding combobox
		for (i = 0; i < comboBoxFormat->Items->Count; i++)
		{
			cbItem = (ComboBoxItem^)(comboBoxFormat->Items[i]);
			if (safe_cast<TPCANTPFormatType>(cbItem->Data) == mapping->m_formatType)
			{
				comboBoxFormat->SelectedIndex = i;
				break;
			}
		}
		// select target type in corresponding combobox
		for (i = 0; i < comboBoxTargetType->Items->Count; i++)
		{
			cbItem = (ComboBoxItem^)(comboBoxTargetType->Items[i]);
			if (safe_cast<TPCANTPAddressingType>(cbItem->Data) == mapping->m_targetType)
			{
				comboBoxTargetType->SelectedIndex = i;
				break;
			}
		}
		// set CAN ID & CAN ID response
		numericUpDownCanId->Value = mapping->m_canId;
		numericUpDownCanIdResp->Value = mapping->m_canIdResponse;
		// set addresses
		numericUpDownSourceAddr->Value = mapping->m_sourceAddr;
		numericUpDownTargetAddr->Value = mapping->m_targetAddr;
		numericUpDownRemoteAddr->Value = mapping->m_remoteAddr;
		// update UI components based on selected values
		updateUi();
	}
	/// <summary>
	/// Fills the comboBox "Message Type" based on pre-selected inputs.
	/// </summary>
	/// <param name="idType">CAN ID Type of the mapping.</param>
	void fillComboBoxMsgType(TPCANTPIdType idType)
	{
		ComboBoxItem ^cbItem = nullptr;

		if (comboBoxFormat->SelectedItem == nullptr)
			cbItem = nullptr;
		else
			cbItem = (ComboBoxItem^)comboBoxFormat->SelectedItem;
		comboBoxFormat->Items->Clear();

		// fill message type combobox
		comboBoxMsgType->Items->Add(gcnew ComboBoxItem(
			"PCANTP_MESSAGE_DIAGNOSTIC",
			TPCANTPMessageType::PCANTP_MESSAGE_DIAGNOSTIC));
		if (idType == TPCANTPIdType::PCANTP_ID_CAN_11BIT)
		{
			comboBoxMsgType->Items->Add(gcnew ComboBoxItem(
				"PCANTP_MESSAGE_REMOTE_DIAGNOSTIC",
				TPCANTPMessageType::PCANTP_MESSAGE_REMOTE_DIAGNOSTIC));
		}
		// reminder: PCANTP_FORMAT_ENHANCED (29bits only) does NOT require mapping
		comboBoxFormat->SelectedItem = cbItem;
	}
	/// <summary>
	/// Fills the comboBox "Format Type" based on pre-selected inputs.
	/// </summary>
	/// <param name="idType">CAN ID Type of the mapping.</param>
	/// <param name="msgType">Message Type of the mapping.</param>
	void fillComboBoxFormatType(TPCANTPIdType idType, TPCANTPMessageType msgType)
	{
		ComboBoxItem ^cbItem = nullptr;

		if (comboBoxFormat->SelectedItem == nullptr)
			cbItem = nullptr;
		else
			cbItem = (ComboBoxItem^)comboBoxFormat->SelectedItem;
		comboBoxFormat->Items->Clear();

		switch (msgType)
		{
		case TPCANTPMessageType::PCANTP_MESSAGE_DIAGNOSTIC:
		default:
			comboBoxFormat->Items->Add(gcnew ComboBoxItem(
				"PCANTP_FORMAT_NORMAL",
				TPCANTPFormatType::PCANTP_FORMAT_NORMAL));
			comboBoxFormat->Items->Add(gcnew ComboBoxItem(
				"PCANTP_FORMAT_EXTENDED",
				TPCANTPFormatType::PCANTP_FORMAT_EXTENDED));
			// reminder: PCANTP_FORMAT_FIXED_NORMAL does NOT require mapping
			break;
		case TPCANTPMessageType::PCANTP_MESSAGE_REMOTE_DIAGNOSTIC:
			// reminder: PCANTP_FORMAT_MIXED does NOT require mapping with 29 bits CAN ID
			if (idType == TPCANTPIdType::PCANTP_ID_CAN_11BIT)
			{
				comboBoxFormat->Items->Add(gcnew ComboBoxItem(
					"PCANTP_FORMAT_MIXED",
					TPCANTPFormatType::PCANTP_FORMAT_MIXED));
			}
			break;
		}
		// reminder: PCANTP_FORMAT_ENHANCED (29bits only) does NOT require mapping
		comboBoxFormat->SelectedItem = cbItem;
	}
	/// <summary>
	/// Checks consistency of components selection.
	/// </summary>
	void updateUi()
	{
		// note: we do not update component member "Enabled" directly
		// to prevent flickering.
		bool radioButtonCanId11b_Enabled = true;
		bool radioButtonCanId29b_Enabled = true;
		bool comboBoxMsgType_Enabled = false;
		bool comboBoxFormat_Enabled = false;
		bool comboBoxTargetType_Enabled = false;
		bool numericUpDownCanId_Enabled = false;
		bool numericUpDownCanIdResp_Enabled = false;
		bool numericUpDownSourceAddr_Enabled = false;
		bool numericUpDownTargetAddr_Enabled = false;
		bool numericUpDownRemoteAddr_Enabled = false;

		// ID type must be set to continue
		if (!radioButtonCanId11b->Checked && !radioButtonCanId29b->Checked)
			return;
		comboBoxMsgType_Enabled = true;
		// Message type must be set to continue
		if (getSelectedMsgType() != TPCANTPMessageType::PCANTP_MESSAGE_UNKNOWN)
		{
			switch (getSelectedMsgType())
			{
			case TPCANTPMessageType::PCANTP_MESSAGE_REMOTE_DIAGNOSTIC:
				numericUpDownRemoteAddr_Enabled = true;
				break;
			case TPCANTPMessageType::PCANTP_MESSAGE_DIAGNOSTIC:
				// do NOT enable remote address
				numericUpDownRemoteAddr->Value = 0x00;
				break;
			}
			comboBoxFormat_Enabled = true;
			// Format type must be set to continue
			if (getSelectedFormatType() != TPCANTPFormatType::PCANTP_FORMAT_UNKNOWN)
			{
				comboBoxTargetType_Enabled = true;
				// Target type must be set to continue
				if (getSelectedTargetType() != TPCANTPAddressingType::PCANTP_ADDRESSING_UNKNOWN)
				{
					switch (getSelectedTargetType())
					{
					case TPCANTPAddressingType::PCANTP_ADDRESSING_FUNCTIONAL:
						// do NOT enable CAN ID response
						break;
					case TPCANTPAddressingType::PCANTP_ADDRESSING_PHYSICAL:
						numericUpDownCanIdResp_Enabled = true;
						break;
					}
					numericUpDownCanId_Enabled = true;
					numericUpDownSourceAddr_Enabled = true;
					numericUpDownTargetAddr_Enabled = true;
				}
			}
		}

		this->SuspendLayout();
		radioButtonCanId11b->Enabled = radioButtonCanId11b_Enabled;
		radioButtonCanId29b->Enabled = radioButtonCanId29b_Enabled;
		comboBoxMsgType->Enabled = comboBoxMsgType_Enabled;
		comboBoxFormat->Enabled = comboBoxFormat_Enabled;
		comboBoxTargetType->Enabled = comboBoxTargetType_Enabled;
		numericUpDownCanId->Enabled = numericUpDownCanId_Enabled;
		numericUpDownCanIdResp->Enabled = numericUpDownCanIdResp_Enabled;
		numericUpDownSourceAddr->Enabled = numericUpDownSourceAddr_Enabled;
		numericUpDownTargetAddr->Enabled = numericUpDownTargetAddr_Enabled;
		numericUpDownRemoteAddr->Enabled = numericUpDownRemoteAddr_Enabled;
		buttonOk->Enabled = checkMapping();
		this->ResumeLayout();
	}
	/// <summary>
	/// Chekcs that all the values for the mapping are filled in.
	/// </summary>
	/// <returns>true if the values are set, false otherwise</returns>
	private: bool checkMapping()
	{
		UInt32 canId;
		UInt32 canIdResp;
		TPCANTPIdType canIdType;
		TPCANTPFormatType format;
		TPCANTPMessageType msgType;
		TPCANTPAddressingType targetType;
		Byte sourceAddr;
		Byte targetAddr;
		Byte remoteAddr;

		// get mapping values
		try {
			canId = Convert::ToUInt32(numericUpDownCanId->Value);
			canIdResp = Convert::ToUInt32(numericUpDownCanIdResp->Value);
			canIdType = getSelectedIdType();
			msgType = getSelectedMsgType();
			format = getSelectedFormatType();
			targetType = getSelectedTargetType();
			sourceAddr = Convert::ToByte(numericUpDownSourceAddr->Value);
			targetAddr = Convert::ToByte(numericUpDownTargetAddr->Value);
			remoteAddr = Convert::ToByte(numericUpDownRemoteAddr->Value);
		}
		catch (Exception ^ex)
		{
			MessageBox::Show(ex->Message, "PCAN-ISO-TP Example", MessageBoxButtons::OK, MessageBoxIcon::Error);
			return false;
		}
		// check comboboxes selection
		if (msgType == TPCANTPMessageType::PCANTP_MESSAGE_UNKNOWN)
			return false;
		if (format == TPCANTPFormatType::PCANTP_FORMAT_UNKNOWN)
			return false;
		if (targetType == TPCANTPAddressingType::PCANTP_ADDRESSING_UNKNOWN)
			return false;

		// Functional addressing is a one way communication,
		// there is no need to check the target 
		if (targetType != TPCANTPAddressingType::PCANTP_ADDRESSING_FUNCTIONAL)
		{
			// source and target addresses should not be the same
			// thus it is the same for the CAN IDs 
			if (sourceAddr == targetAddr || canId == canIdResp)
				return false;
		}
		return true;
	}
	
#pragma region Event Handlers
	System::Void comboBoxMsgType_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
		// available format type is dependant of the can id type and the message type
		fillComboBoxFormatType(getSelectedIdType(), getSelectedMsgType());
		// update OK button
		uiComponent_Leave(this, EventArgs::Empty);
	}

	System::Void comboBoxFormat_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
		if (getSelectedFormatType() == TPCANTPFormatType::PCANTP_FORMAT_MIXED)
		{
			numericUpDownRemoteAddr->Enabled = true;
		}
		else
		{
			numericUpDownRemoteAddr->Enabled = false;
			numericUpDownRemoteAddr->Value = 0x00;
		}
		// update OK button
		uiComponent_Leave(this, EventArgs::Empty);
	}

	System::Void comboBoxTargetType_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
		if (getSelectedTargetType() == TPCANTPAddressingType::PCANTP_ADDRESSING_FUNCTIONAL)
		{
			numericUpDownCanIdResp->Maximum = Peak::Can::IsoTp::CanTpApi::CAN_ID_NO_MAPPING;
			numericUpDownCanIdResp->Value = Peak::Can::IsoTp::CanTpApi::CAN_ID_NO_MAPPING;
			numericUpDownCanIdResp->Enabled = false;
		}
		else
		{
			numericUpDownCanIdResp->Maximum = numericUpDownCanId->Maximum;
			numericUpDownCanIdResp->Enabled = true;
			numericUpDownTargetAddr->Enabled = true;
		}
		// update OK button
		uiComponent_Leave(this, EventArgs::Empty);
	}

	void radioButtonCanId_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
	{
		// update maximum CAN ID values
		if (radioButtonCanId11b->Checked)
			numericUpDownCanId->Maximum = 0x7FF;
		else
			numericUpDownCanId->Maximum = 0x1FFFFFFF;
		numericUpDownCanIdResp->Maximum = numericUpDownCanId->Maximum;
		// available format type is dependant of the can id type and the message type
		fillComboBoxFormatType(getSelectedIdType(), getSelectedMsgType());
		// update OK button
		uiComponent_Leave(this, EventArgs::Empty);
	}

	System::Void numericUpDownCanId_ValueChanged(System::Object^  sender, System::EventArgs^  e) {
		// update OK button
		uiComponent_Leave(this, EventArgs::Empty);
	}

	System::Void buttonOk_Click(System::Object^  sender, System::EventArgs^  e) {
		// get mapping values
		try
		{
			m_mapping->m_canId = Convert::ToUInt32(numericUpDownCanId->Value);
			m_mapping->m_canIdResponse = Convert::ToUInt32(numericUpDownCanIdResp->Value);
			m_mapping->m_canIdType = getSelectedIdType();
			m_mapping->m_msgType = getSelectedMsgType();
			m_mapping->m_formatType = getSelectedFormatType();
			m_mapping->m_targetType = getSelectedTargetType();
			m_mapping->m_sourceAddr = Convert::ToByte(numericUpDownSourceAddr->Value);
			m_mapping->m_targetAddr = Convert::ToByte(numericUpDownTargetAddr->Value);
			m_mapping->m_remoteAddr = Convert::ToByte(numericUpDownRemoteAddr->Value);
		}
		catch (Exception ^ex)
		{
			MessageBox::Show(ex->Message, "PCAN-ISO-TP Example", MessageBoxButtons::OK, MessageBoxIcon::Error);
			this->DialogResult = System::Windows::Forms::DialogResult::None;
		}
	}

	System::Void numericUpDownComponents_ValueChanged(System::Object^  sender, System::EventArgs^  e) {
		// update OK button
		uiComponent_Leave(this, EventArgs::Empty);
	}

	void uiComponent_Leave(System::Object^  sender, System::EventArgs^  e)
	{
		updateUi();
	}
#pragma endregion

#pragma region UI Getters
	/// <summary>
	/// Returns the selected CAN ID Type.
	/// </summary>
	/// <returns>The selected CAN ID Type (PCANTP_ID_CAN_11BIT if none is selected).</returns>
	TPCANTPIdType getSelectedIdType()
	{
		if (radioButtonCanId29b->Checked)
			return TPCANTPIdType::PCANTP_ID_CAN_29BIT;
		return TPCANTPIdType::PCANTP_ID_CAN_11BIT;
	}
	/// <summary>
	/// Returns the selected ISO-TP Message Type.
	/// </summary>
	/// <returns>The selected ISO-TP Message Type (PCANTP_MESSAGE_UNKNOWN if none is selected).</returns>
	TPCANTPMessageType getSelectedMsgType()
	{
		if (comboBoxMsgType->SelectedItem == nullptr)
			return TPCANTPMessageType::PCANTP_MESSAGE_UNKNOWN;
		return safe_cast<TPCANTPMessageType>(((ComboBoxItem^)(comboBoxMsgType->SelectedItem))->Data);
	}
	/// <summary>
	/// Returns the selected ISO-TP Format Type.
	/// </summary>
	/// <returns>The selected ISO-TP Format Type (PCANTP_FORMAT_UNKNOWN if none is selected).</returns>
	TPCANTPFormatType getSelectedFormatType()
	{
		if (comboBoxFormat->SelectedItem == nullptr)
			return TPCANTPFormatType::PCANTP_FORMAT_UNKNOWN;
		return safe_cast<TPCANTPFormatType>(((ComboBoxItem^)(comboBoxFormat->SelectedItem))->Data);
	}
	/// <summary>
	/// Returns the selected ISO-TP Target Addressing Type.
	/// </summary>
	/// <returns>The selected ISO-TP Target Addressing Type (PCANTP_ADDRESSING_UNKNOWN if none is selected).</returns>
	TPCANTPAddressingType getSelectedTargetType()
	{
		if (comboBoxTargetType->SelectedItem == nullptr)
			return TPCANTPAddressingType::PCANTP_ADDRESSING_UNKNOWN;
		return safe_cast<TPCANTPAddressingType>(((ComboBoxItem^)(comboBoxTargetType->SelectedItem))->Data);
	}
#pragma endregion

};
}
